import connect from '../objects/connect.js'
import CubicBezier from 'cubic-bezier-easing'

const Easing = {
  linear :  new CubicBezier(0, 0, 1, 1,'linear'),
  easingSinusoidalIn : new CubicBezier(0.47, 0, 0.745, 0.715,'easingSinusoidalIn'),
  easingSinusoidalOut : new CubicBezier(0.39, 0.575, 0.565, 1,'easingSinusoidalOut'),
  easingSinusoidalInOut : new CubicBezier(0.445, 0.05, 0.55, 0.95,'easingSinusoidalInOut'),
  
  easingQuadraticIn : new CubicBezier(0.550, 0.085, 0.680, 0.530,'easingQuadraticIn'),
  easingQuadraticOut : new CubicBezier(0.250, 0.460, 0.450, 0.940,'easingQuadraticOut'),
  easingQuadraticInOut : new CubicBezier(0.455, 0.030, 0.515, 0.955,'easingQuadraticInOut'),
  
  easingCubicIn : new CubicBezier(0.55, 0.055, 0.675, 0.19,'easingCubicIn'),
  easingCubicOut : new CubicBezier(0.215, 0.61, 0.355, 1,'easingCubicOut'),
  easingCubicInOut : new CubicBezier(0.645, 0.045, 0.355, 1,'easingCubicInOut'),
  
  easingQuarticIn : new CubicBezier(0.895, 0.03, 0.685, 0.22,'easingQuarticIn'),
  easingQuarticOut : new CubicBezier(0.165, 0.84, 0.44, 1,'easingQuarticOut'),
  easingQuarticInOut : new CubicBezier(0.77, 0, 0.175, 1,'easingQuarticInOut'),
  
  easingQuinticIn : new CubicBezier(0.755, 0.05, 0.855, 0.06,'easingQuinticIn'),
  easingQuinticOut : new CubicBezier(0.23, 1, 0.32, 1,'easingQuinticOut'),
  easingQuinticInOut : new CubicBezier(0.86, 0, 0.07, 1,'easingQuinticInOut'),
  
  easingExponentialIn : new CubicBezier(0.95, 0.05, 0.795, 0.035,'easingExponentialIn'),
  easingExponentialOut : new CubicBezier(0.19, 1, 0.22, 1,'easingExponentialOut'),
  easingExponentialInOut : new CubicBezier(1, 0, 0, 1,'easingExponentialInOut'),
  
  easingCircularIn : new CubicBezier(0.6, 0.04, 0.98, 0.335,'easingCircularIn'),
  easingCircularOut : new CubicBezier(0.075, 0.82, 0.165, 1,'easingCircularOut'),
  easingCircularInOut : new CubicBezier(0.785, 0.135, 0.15, 0.86,'easingCircularInOut'),
  
  easingBackIn : new CubicBezier(0.6, -0.28, 0.735, 0.045,'easingBackIn'),
  easingBackOut : new CubicBezier(0.175, 0.885, 0.32, 1.275,'easingBackOut'),
  easingBackInOut : new CubicBezier(0.68, -0.55, 0.265, 1.55,'easingBackInOut')
}

function processBezierEasing(fn) {
  if ( typeof fn === 'function') {
    return fn;
  } else if (typeof(Easing[fn]) === 'function') {
    return Easing[fn];
  } else if ( /bezier/.test(fn) ) {
    var bz = fn.replace(/bezier|\s|\(|\)/g,'').split(',');
    return new CubicBezier( bz[0]*1,bz[1]*1,bz[2]*1,bz[3]*1 ); //bezier easing 
  } else {
    if ( /elastic|bounce/i.test(fn) ) {
      console.warn(`KUTE.js - CubicBezier doesn't support ${fn} easing.`)
    }
    return Easing.linear
  }
}

connect.processEasing = processBezierEasing

export default Easing